clear all

* Set Folder to output one

cd ..\Outputs

* Call dataset of revisions and shocks combined (COMB)

use COMB, clear

gen time=year+(qua-1)/4
egen t=group(year quarter)
tsset t

capture drop MPOa
gen MPOa=MPO
replace MPOa=0 if MPO==. & year>2008

gen dlogY=log(GDPC96/l.GDPC96)*400

* Dummy variable for the Great Recession

gen DGR=(time==2008 | time==2008.25 | time==2008.5 | time==2008.75 | time==2009 | time==2009.25)
			 
local confidenceval=0.95

if `confidenceval'==1.65 local confidencestr="90%"
if `confidenceval'==0.95 local confidencestr="66%"

*===============================================================================
*			        Variables with contemporanous response
*===============================================================================

replace dlogY_BQfs_demand_shock=-dlogY_BQfs_demand_shock

quiet foreach var in dlogY_BQfs_demand_shock dlogY_BQfs_supply_shock   {

	noisily di "====================================================="
	noisily di "			           `var'"
	noisily di "====================================================="
	
	* Define strings for titles of IRF figures
	
	if "`var'"=="dlogY_BQfs_demand_shock" local var_str="Panel A. BQ demand shock"
	if "`var'"=="dlogY_BQfs_supply_shock" local var_str="Panel B. BQ supply shock"
	
	capture drop Z*
	gen Z=`var'
	sum Z
	replace Z=Z/r(sd)
	
	* Create current and lagged values of the shock
	
	forvalues i=0(1)8 {
		gen Z`i'=l`i'.Z
	}
	
	reg GREgRpot0 dlogY Z?
	capture drop smpl0
	gen smpl0=e(sample)
	drop Z
	
	capture drop irf*
	*** time for IRFs
	gen irf_0=t-1
	
	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	*				          IRF for potential output
	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	newey GREgRpot0 Z* D911 DGR if smpl0==1, lag(4)
	
	gen irf_pot_m=.
	gen irf_pot_se=.
	local str0="Z0"
	lincom "`str0'"
	replace irf_pot_m=r(estimate) if irf_0==0
	replace irf_pot_se=r(se) if irf_0==0
		
	forvalues i=1(1)8 {
		local str0="`str0'" + "+Z`i'" 
		lincom "`str0'"
		replace irf_pot_m=r(estimate) if irf_0==`i'
		replace irf_pot_se=r(se) if irf_0==`i'
	}	
	
	gen irf_pot_m_up=irf_pot_m+`confidenceval'*irf_pot_se
	gen irf_pot_m_lo=irf_pot_m-`confidenceval'*irf_pot_se
	
	*** test cumulative sum for the potential is zero
	lincom Z0+Z1+Z2+Z3+Z4+Z5+Z6+Z7+Z8
	local pval_pot_irf=strofreal((1-normal(abs(r(estimate)/r(se))))*2,"%4.3f") 
	
	*** test pointwise that the potential output IRF (growth rate) is zero for the growth rate
	test Z0 Z1 Z2 Z3 Z4 Z5 Z6 Z7 Z8
	local pval_pot_irf_point=strofreal(r(p),"%4.3f") 

	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	*				          IRF for actual output
	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	newey dlogY Z* D911 DGR if smpl0==1, lag(4)

	gen irf_act_m=.
	gen irf_act_se=.	
	local str0="Z0"
	lincom "`str0'"
	replace irf_act_m=r(estimate) if irf_0==0
	replace irf_act_se=r(se) if irf_0==0
		
	forvalues i=1(1)8 {
		local str0="`str0'" + "+Z`i'" 
		lincom "`str0'"
		replace irf_act_m=r(estimate) if irf_0==`i'
		replace irf_act_se=r(se) if irf_0==`i'
	}		
		
	gen irf_act_m_up=irf_act_m+`confidenceval'*irf_act_se
	gen irf_act_m_lo=irf_act_m-`confidenceval'*irf_act_se		

	*** test cumulative sum for the actual is zero	
	lincom Z0+Z1+Z2+Z3+Z4+Z5+Z6+Z7+Z8
	local pval_act_irf=strofreal((1-normal(abs(r(estimate)/r(se))))*2,"%4.3f")
	*** test pointwise that the actual output IRF (growth rate) is zero for the growth rate
	test Z0 Z1 Z2 Z3 Z4 Z5 Z6 Z7 Z8
	local pval_act_irf_point=strofreal(r(p),"%4.3f") 

	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	*				   IRF for actual output - potential
	*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	
	capture drop D_actual_minus_potential
	gen D_actual_minus_potential=dlogY-GREgRpot0
	newey D_actual_minus_potential Z* D911 DGR if smpl0==1, lag(4)

	*** test cumulative sum for the actual is zero	
	lincom Z0+Z1+Z2+Z3+Z4+Z5+Z6+Z7+Z8
	local pval_dif_irf=strofreal((1-normal(abs(r(estimate)/r(se))))*2,"%4.3f")

	*** test pointwise that the actual output IRF (growth rate) is zero for the growth rate
	test Z0 Z1 Z2 Z3 Z4 Z5 Z6 Z7 Z8
	local pval_dif_irf_point=strofreal(r(p),"%4.3f") 

	noisily di "p-val equality of IRFs:  (`pval_dif_irf') [`pval_dif_irf_point']"
	noisily di "p-val actual IRF:  (`pval_act_irf') [`pval_act_irf_point']"
	noisily di "p-val potential IRF: (`pval_pot_irf') [`pval_pot_irf_point']"
	
	twoway ///
	(rarea irf_act_m_lo irf_act_m_up irf_0 if irf_0<=8, color(gs14)) ///
	(line irf_act_m  irf_0 if irf_0<=8, lcolor(black) lpattern(solid) lwidth(thick)) ///
	(line irf_pot_m  irf_0 if irf_0<=8, lcolor(blue) lpattern(solid)) ///
	(line irf_pot_m_up  irf_0 if irf_0<=8, lcolor(blue) lpattern(dash)) ///
	(line irf_pot_m_lo  irf_0 if irf_0<=8, lcolor(blue) lpattern(dash)) ///
	, ///
	xtitle("") xlabel(0(1)8) ///
	ytitle("output growth rate, percent, annualized") ///
	title("`var_str'") ///
	legend(order(2 1 3 4 6) ///
	label(1 "`confidencestr' CI") ///
	label(2 "Actual Output, (`pval_act_irf') [`pval_act_irf_point']") ///
	label(3 "Poten. Output, (`pval_pot_irf') [`pval_pot_irf_point']") ///
	label(4 "`confidencestr' CI") ///
	label(6 "Actual=Poten., (`pval_dif_irf') [`pval_dif_irf_point']") ///
	rows(3) ring(3) position(7)) ///
	graphregion(color(white)) bgcolor(white) ///
	name(`var', replace)
		
}

window manage close graph _all

graph combine dlogY_BQfs_demand_shock dlogY_BQfs_supply_shock, ///
	rows(2) ysize(3) xsize(2) graphregion(color(white)) plotregion(color(white))
